#include <stdio.h>
#include <stdlib.h>
#include <math.h>


typedef struct {
    int x, y;
} T;


int orr(T a, T b, T c) {
    int val = (b.y - a.y) * (c.x - b.x) - (b.x - a.x) * (c.y - b.y);
    if (val == 0) return 0;
    return (val > 0) ? 1 : -1; 
}


int poredjenje(const void* p1, const void* p2) {
    T* a = (T*)p1;
    T* b = (T*)p2;
    if (a->x == b->x) return a->y - b->y; 
    return a->x - b->x; 
}


double monougaoP(T* H, int n) {
    double P = 0.0;
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n; 
        P += H[i].x * H[j].y - H[i].y * H[j].x;
    }
    return fabs(P) / 2.0;
}


int cH(T* Ts, int n, T* H) {
    qsort(Ts, n, sizeof(T), poredjenje); 

    int size = 0;

    
    for (int i = 0; i < n; i++) {
        while (size >= 2 && orr(H[size - 2], H[size - 1], Ts[i]) <= 0) {
            size--; 
        }
        H[size++] = Ts[i]; 
    }

   
    int g = size;
    for (int i = n - 2; i >= 0; i--) {
        while (size > g && orr(H[size - 2], H[size - 1], Ts[i]) <= 0) {
            size--; 
        }
        H[size++] = Ts[i]; 
    }

    size--; 
    return size; 
}

int main() {
    int N;
    printf("Unesite broj tacaka: ");
    scanf("%d", &N); 

    T Ts[N], temp[N], H[N]; 
    for (int i = 0; i < N; i++) {
        printf("Unesite koordinate tacke %d (x y): ", i + 1);
        scanf("%d %d", &Ts[i].x, &Ts[i].y);
    }

    double minP = 1e9; 

    
    for (int i = 0; i < N; i++) {
        int k = 0;

        
        for (int j = 0; j < N; j++) {
            if (j != i) temp[k++] = Ts[j];
        }

        
        int size = cH(temp, k, H);

        
        double P = monougaoP(H, size);
        if (P < minP) {
            minP = P; 
        }
    }

    printf("Minimalna povrsina konveksnog skoro-omotaca je: %.1f\n", minP); 
    return 0;
}